# This script is test_enan.sh
cd PHASES
#
# ORIGINAL ENANTIOMORPH
touch test_hand.In_Use                                                          
touch test_hand.log                                                             
#
# COMPUTE STRUCTURE FACTORS
/Users/snbdev/bnp0.99/phases/phasit < phasit.d > temp.l                         
mv phasit.d test_hand.NEWPARAMS                                                 
#
# COMPUTE ORIGINAL ELECTRON DENSITY MAP
ln test_hand.31 four.ref                                                        
/Users/snbdev/bnp0.99/phases/fsfour < fft.d >> temp.l                           
mv four.map orig.map
rm four.ref
ln orig.map four.map
#
# COMPUTE THE FIRST SOLVENT MASK 
# REMOVE HEAVY-ATOM PEAKS FROM MAP
#
# INVERT MAP AFTER TRUNCATING DENSITY < 0
/Users/snbdev/bnp0.99/phases/mapinv < minv1.d >> temp.l                         
rm four.map
#
# MULTIPLY FOURIER COEFFICIENT BY TRANSFORM OF WEIGHTING FUNCTION
/Users/snbdev/bnp0.99/phases/bndry < bnd0.d >> temp.l                           
rm minv.ref
#
# COMPUTE "SMEARED" MAP FROM MODIFIED COEF
/Users/snbdev/bnp0.99/phases/fsfour < fft.d >> temp.l                           
rm four.ref
#
# DETERMINE PROTEIN-SOLVENT BOUNDARY MASK FROM "SMEARED" MAP
/Users/snbdev/bnp0.99/phases/bndry < bnd1.d >> temp.l                           
mv mask.map mask1.14
rm four.map
#
# COMPUTE PROTEIN & SOLVENT DENSITY STATISTICS
mv orig.map four.map
ln mask1.14 mask.map
/Users/snbdev/bnp0.99/phases/bndry_hand < bndh.d >> temp.l                      
rm four.map mask.map
#
mv hand_stats.dat orig_hand.dat
mv temp.l test_hand.log                                                         
rm test_hand.In_Use                                                             
mv mmepi_en.pam mmepi.pam                                                       
#
# ALTERNATE ENANTIOMORPH
touch test_hand_en.In_Use                                                       
touch test_hand_en.log                                                          
#
# COMPUTE STRUCTURE FACTORS
/Users/snbdev/bnp0.99/phases/phasit < phasit_en.d > temp.l                      
mv phasit_en.d test_hand_en.NEWPARAMS                                           
#
# COMPUTE ORIGINAL ELECTRON DENSITY MAP
ln test_hand_en.31 four.ref                                                     
/Users/snbdev/bnp0.99/phases/fsfour < fft.d >> temp.l                           
mv four.map orig.map
rm four.ref
ln orig.map four.map
#
# COMPUTE THE FIRST SOLVENT MASK 
# REMOVE HEAVY-ATOM PEAKS FROM MAP
#
# INVERT MAP AFTER TRUNCATING DENSITY < 0
/Users/snbdev/bnp0.99/phases/mapinv < minv1.d >> temp.l                         
rm four.map
#
# MULTIPLY FOURIER COEFFICIENT BY TRANSFORM OF WEIGHTING FUNCTION
/Users/snbdev/bnp0.99/phases/bndry < bnd0.d >> temp.l                           
rm minv.ref
#
# COMPUTE "SMEARED" MAP FROM MODIFIED COEF
/Users/snbdev/bnp0.99/phases/fsfour < fft.d >> temp.l                           
rm four.ref
#
# DETERMINE PROTEIN-SOLVENT BOUNDARY MASK FROM "SMEARED" MAP
/Users/snbdev/bnp0.99/phases/bndry < bnd1.d >> temp.l                           
mv mask.map mask1.14
rm four.map
#
# COMPUTE PROTEIN & SOLVENT DENSITY STATISTICS
mv orig.map four.map
ln mask1.14 mask.map
/Users/snbdev/bnp0.99/phases/bndry_hand < bndh.d >> temp.l                      
rm four.map mask.map
#
mv hand_stats.dat other_hand.dat
mv temp.l test_hand_en.log                                                      
rm test_hand_en.In_Use                                                          
#
# COMPARE HANDS
/Users/snbdev/bnp0.99/phases/compare_hand << eod > compare_hand.l               
 1 ! Both iso and ano data
         0
P21     
eod
rm orig_hand.dat other_hand.dat
